float4x4 matView;
float4x4 matProjection;
float4x4 matViewProjection;
float4x4 matWorld;
float4x4 matWorldView;
float4x4 matWorldViewProjection;

float var1; 

texture tex0;
sampler sTex0 = sampler_state
{
	texture = (tex0);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

struct VS_OUTPUT 
{
	float4 pos : POSITION;
	float2 tc : TEXCOORD0;
};

VS_OUTPUT tissVS(float2 tc : TEXCOORD0,float4 position : POSITION)
{
	VS_OUTPUT o;
	o.pos = mul(position, matProjection);
	o.tc = tc;
	return o;
}

float4 pissPS(float2 tc : TEXCOORD0,float4 position : POSITION) : COLOR0
{
	return tex2D(sTex0, tc)*var1; 
}

technique tull
{
	pass sull
	{
		VertexShader = compile vs_2_0 tissVS();
		PixelShader  = compile ps_2_0 pissPS(); 
	}
}